<?php
session_start();

// Include the PDO configuration file
require 'config.php';
include 'headeradmin.php';

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Retrieve user ID from the session
$user_id = $_SESSION['user_id'];

// Query to get user status
$sql = "SELECT status FROM users WHERE id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$user = $stmt->fetch();

if (!$user || $user['status'] != 2) {
    header('Location: login.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings</title>
    <link rel="stylesheet" href="styles.css"> <!-- Link to your stylesheet -->
</head>
<body>
    <div class="settings-container">
        <center>
            <h2>Admin Settings Coming Soon</h2>
        </center>
    </div>
</body>
</html>
